-- phpMyAdmin SQL Dump
-- version 5.2.2
-- https://www.phpmyadmin.net/
--
-- Servidor: localhost:3306
-- Tiempo de generación: 04-12-2025 a las 19:21:53
-- Versión del servidor: 10.11.13-MariaDB
-- Versión de PHP: 8.3.25

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de datos: `manuelgrupodvh_panda`
--

DELIMITER $$
--
-- Procedimientos
--
CREATE DEFINER=`manuelgrupodvh`@`localhost` PROCEDURE `crear_pedido` (IN `p_usuario_id` INT, IN `p_direccion` TEXT, IN `p_telefono` VARCHAR(20), IN `p_notas` TEXT)   BEGIN
     DECLARE v_total DECIMAL(10,2);
     DECLARE v_pedido_id INT;
    
     -- Calcular total del carrito
     SELECT SUM(p.precio * ct.cantidad) INTO v_total
     FROM carrito_temporal ct
     JOIN productos p ON ct.producto_id = p.id
     WHERE ct.usuario_id = p_usuario_id;
    
     -- Insertar pedido
     INSERT INTO pedidos (usuario_id, total, direccion_entrega, telefono_contacto, notas)
     VALUES (p_usuario_id, v_total, p_direccion, p_telefono, p_notas);
    
     SET v_pedido_id = LAST_INSERT_ID();
    
     -- Insertar detalles del pedido
     INSERT INTO pedido_detalles (pedido_id, producto_id, cantidad, precio_unitario, subtotal)
     SELECT 
         v_pedido_id,
         ct.producto_id,
         ct.cantidad,
         p.precio,
         (p.precio * ct.cantidad)
     FROM carrito_temporal ct
     JOIN productos p ON ct.producto_id = p.id
     WHERE ct.usuario_id = p_usuario_id;
    
     -- Limpiar carrito
     DELETE FROM carrito_temporal WHERE usuario_id = p_usuario_id;
    
     -- Retornar ID del pedido creado
     SELECT v_pedido_id AS pedido_id;
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `carrito_temporal`
--

CREATE TABLE `carrito_temporal` (
  `id` int(11) NOT NULL,
  `usuario_id` int(11) NOT NULL,
  `producto_id` int(11) NOT NULL,
  `cantidad` int(11) NOT NULL DEFAULT 1,
  `fecha_agregado` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `categorias`
--

CREATE TABLE `categorias` (
  `id` int(11) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `descripcion` text DEFAULT NULL,
  `imagen` varchar(255) DEFAULT NULL,
  `activa` tinyint(1) DEFAULT 1,
  `fecha_creacion` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `categorias`
--

INSERT INTO `categorias` (`id`, `nombre`, `descripcion`, `imagen`, `activa`, `fecha_creacion`) VALUES
(1, 'Hamburguesas 🍔', 'Nuestras especialidades en pan.', NULL, 1, '2025-11-26 16:48:31'),
(2, 'Pizzas 🍕', 'Perfectas para compartir o disfrutar solo.', NULL, 1, '2025-11-26 16:48:31'),
(3, 'Bebidas 🥤', 'Refrescos, jugos y café.', NULL, 1, '2025-11-26 16:48:31'),
(4, 'Ensaladas 🥗', 'Frescas y saludables.', NULL, 1, '2025-11-26 16:48:31'),
(5, 'Platos Fuertes 🍛', 'Nuestras especialidades principales.', NULL, 1, '2025-11-26 16:48:31'),
(6, 'Aperitivos 🍟', 'Para empezar con el pie derecho.', NULL, 1, '2025-11-26 16:48:31'),
(7, 'Postres 🍰', 'El final perfecto para tu comida.', NULL, 1, '2025-11-26 16:48:31'),
(8, 'Desayunos 🥞', 'Ideales para comenzar el día.', NULL, 1, '2025-11-26 16:48:31');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `favoritos`
--

CREATE TABLE `favoritos` (
  `id` int(11) NOT NULL,
  `usuario_id` int(11) NOT NULL,
  `producto_id` int(11) NOT NULL,
  `fecha_agregado` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `pedidos`
--

CREATE TABLE `pedidos` (
  `id` int(11) NOT NULL,
  `usuario_id` int(11) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `direccion_entrega` text NOT NULL,
  `telefono_contacto` varchar(20) NOT NULL,
  `estado` enum('pendiente','confirmado','preparando','en_camino','entregado','cancelado') DEFAULT 'pendiente',
  `fecha_pedido` timestamp NOT NULL DEFAULT current_timestamp(),
  `fecha_entrega` timestamp NULL DEFAULT NULL,
  `notas` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `pedido_detalles`
--

CREATE TABLE `pedido_detalles` (
  `id` int(11) NOT NULL,
  `pedido_id` int(11) NOT NULL,
  `producto_id` int(11) NOT NULL,
  `cantidad` int(11) NOT NULL DEFAULT 1,
  `precio_unitario` decimal(10,2) NOT NULL,
  `subtotal` decimal(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Disparadores `pedido_detalles`
--
DELIMITER $$
CREATE TRIGGER `before_insert_pedido_detalles` BEFORE INSERT ON `pedido_detalles` FOR EACH ROW BEGIN
    SET NEW.subtotal = NEW.precio_unitario * NEW.cantidad;
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `before_update_pedido_detalles` BEFORE UPDATE ON `pedido_detalles` FOR EACH ROW BEGIN
    SET NEW.subtotal = NEW.precio_unitario * NEW.cantidad;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `productos`
--

CREATE TABLE `productos` (
  `id` int(11) NOT NULL,
  `nombre` varchar(150) NOT NULL,
  `descripcion` text DEFAULT NULL,
  `precio` decimal(10,2) NOT NULL,
  `imagen` varchar(255) DEFAULT NULL,
  `categoria_id` int(11) DEFAULT NULL,
  `disponible` tinyint(1) DEFAULT 1,
  `destacado` tinyint(1) DEFAULT 0,
  `fecha_creacion` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `productos`
--

INSERT INTO `productos` (`id`, `nombre`, `descripcion`, `precio`, `imagen`, `categoria_id`, `disponible`, `destacado`, `fecha_creacion`) VALUES
(1, 'Hamburguesa Clásica', 'Carne, lechuga, tomate, queso', 8.99, 'https://images.unsplash.com/photo-1568901346375-23c9450c58cd?w=500', 1, 1, 0, '2025-11-26 16:48:31'),
(2, 'Hamburguesa Especial', 'Doble carne, bacon, queso cheddar', 12.99, 'https://images.unsplash.com/photo-1572802419224-296b0aeee0d9?w=500', 1, 1, 0, '2025-11-26 16:48:31'),
(3, 'Hamburguesa Pollo', 'Pechuga de pollo, lechuga, mayonesa', 9.99, 'https://images.unsplash.com/photo-1594212699903-ec8a3eca50f5?w=500', 1, 1, 0, '2025-11-26 16:48:31'),
(4, 'Pizza Margarita', 'Salsa tomate, mozzarella, albahaca', 10.99, 'https://images.unsplash.com/photo-1604068549290-dea0e4a305ca?w=500', 2, 1, 0, '2025-11-26 16:48:31'),
(5, 'Pizza Pepperoni', 'Salsa tomate, mozzarella, pepperoni', 13.99, 'https://images.unsplash.com/photo-1628840042765-356cda07504e?w=500', 2, 1, 0, '2025-11-26 16:48:31'),
(6, 'Pizza Hawaiana', 'Jamón, piña y queso mozzarella', 12.50, 'https://images.unsplash.com/photo-1604382355076-af4b0eb60143?w=500', 2, 1, 0, '2025-11-26 16:48:31'),
(7, 'Coca Cola', 'Refresco 500ml', 2.50, 'https://images.unsplash.com/photo-1622483767028-3f66f32aef97?w=500', 3, 1, 0, '2025-11-26 16:48:31'),
(8, 'Jugo de Naranja', 'Jugo natural 300ml', 3.50, 'https://images.unsplash.com/photo-1621506289937-a8e4df240d0b?w=500', 3, 1, 0, '2025-11-26 16:48:31'),
(9, 'Café Americano', 'Café negro americano', 2.00, 'https://images.unsplash.com/photo-1495474472287-4d71bcdd2085?w=500', 3, 1, 0, '2025-11-26 16:48:31'),
(10, 'Ensalada César', 'Lechuga, pollo, crutones, aderezo césar', 7.99, 'https://images.unsplash.com/photo-1546793665-c74683f339c1?w=500', 4, 1, 0, '2025-11-26 16:48:31'),
(11, 'Ensalada Mixta', 'Lechuga, tomate, cebolla, aceitunas', 5.99, 'https://images.unsplash.com/photo-1512621776951-a57141f2eefd?w=500', 4, 1, 0, '2025-11-26 16:48:31'),
(12, 'Ensalada de Atún', 'Atún, lechuga, maíz, tomate', 8.50, 'https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=500', 4, 1, 0, '2025-11-26 16:48:31'),
(13, 'Lomo Saltado', 'Lomo de res, cebolla, tomate, papas fritas', 15.99, 'https://images.unsplash.com/photo-1565299624946-b28f40a0ae38?w=500', 5, 1, 0, '2025-11-26 16:48:31'),
(14, 'Pollo a la Brasa', 'Pollo entero con papas y ensalada', 18.50, 'https://images.unsplash.com/photo-1604503468506-a8da13d82791?w=500', 5, 1, 0, '2025-11-26 16:48:31'),
(15, 'Spaghetti Bolognesa', 'Pasta con salsa de carne', 12.99, 'https://images.unsplash.com/photo-1551892374-ecf8754cf8b0?w=500', 5, 1, 0, '2025-11-26 16:48:31'),
(16, 'Papas Fritas', 'Porción grande con salsa', 4.99, 'https://images.unsplash.com/photo-1573080496219-bb080dd4f877?w=500', 6, 1, 0, '2025-11-26 16:48:31'),
(17, 'Alitas de Pollo', '8 piezas con salsa BBQ', 8.99, 'https://images.unsplash.com/photo-1567620832903-9fc6debc209f?w=500', 6, 1, 0, '2025-11-26 16:48:31'),
(18, 'Nachos', 'Totopos con queso y guacamole', 6.50, 'https://images.unsplash.com/photo-1513456852971-30c0b8199d4d?w=500', 6, 1, 0, '2025-11-26 16:48:31'),
(19, 'Brownie', 'Con nueces y helado de vainilla', 5.99, 'https://images.unsplash.com/photo-1564355808539-22fda35bed7e?w=500', 7, 1, 0, '2025-11-26 16:48:31'),
(20, 'Cheesecake', 'Tarta de queso con frutos rojos', 6.50, 'https://images.unsplash.com/photo-1567306301408-9b74779a11af?w=500', 7, 1, 0, '2025-11-26 16:48:31'),
(21, 'Helado', '3 bolas a elegir', 4.50, 'https://images.unsplash.com/photo-1563805042-7684c019e1cb?w=500', 7, 1, 0, '2025-11-26 16:48:31'),
(22, 'Desayuno Americano', 'Huevos, tocino, tostadas, café', 9.99, 'https://images.unsplash.com/photo-1551782450-17144efb9c50?w=500', 8, 1, 0, '2025-11-26 16:48:31'),
(23, 'Omelette', 'Tres huevos con jamón y queso', 7.50, 'https://images.unsplash.com/photo-1593618998160-e34014e685e7?w=500', 8, 1, 0, '2025-11-26 16:48:31'),
(24, 'Pancakes', 'Stack de 3 pancakes con miel', 6.99, 'https://images.unsplash.com/photo-1567620905732-2d1ec7ab7445?w=500', 8, 1, 0, '2025-11-26 16:48:31');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `usuarios`
--

CREATE TABLE `usuarios` (
  `id` int(11) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `email` varchar(150) NOT NULL,
  `password` varchar(255) NOT NULL,
  `telefono` varchar(20) DEFAULT NULL,
  `direccion` text DEFAULT NULL,
  `fecha_registro` timestamp NOT NULL DEFAULT current_timestamp(),
  `activo` tinyint(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `usuarios`
--

INSERT INTO `usuarios` (`id`, `nombre`, `email`, `password`, `telefono`, `direccion`, `fecha_registro`, `activo`) VALUES
(1, 'Cliente Panda', 'demo@test.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', '123456789', 'Av. Principal 123', '2025-11-26 16:48:31', 1),
(2, 'Jorge ', 'manuelhuamaniccoa16@gmail.com', '$2y$10$V8tAjzBh5aLsACOhBr0vLOyw3wBmUtMC1NncgIP9PARsimjv.GDD6', '912345678', 'lirios', '2025-12-04 14:50:33', 1),
(3, 'Ayde ', 'yessica@gmail.com', '$2y$10$sZ.gZlYtw7ODnYgU9NSNYeYsRzJy2iK3m/I7tObu14kxb34qyooKu', '932345678', 'Ranrapata', '2025-12-04 14:54:52', 1),
(4, 'Dalia', 'Ugarte@gmail.com', '$2y$10$ETHtOrvWxz7Bue5WdXsEIOshIkximywlWKVMGvH6HfYrHm5JttCYi', '983456784', 'velille', '2025-12-04 17:25:18', 1);

-- --------------------------------------------------------

--
-- Estructura Stand-in para la vista `vista_pedidos_completos`
-- (Véase abajo para la vista actual)
--
CREATE TABLE `vista_pedidos_completos` (
`id` int(11)
,`usuario_id` int(11)
,`usuario_nombre` varchar(100)
,`usuario_email` varchar(150)
,`total` decimal(10,2)
,`direccion_entrega` text
,`telefono_contacto` varchar(20)
,`estado` enum('pendiente','confirmado','preparando','en_camino','entregado','cancelado')
,`fecha_pedido` timestamp
,`fecha_entrega` timestamp
,`notas` text
);

-- --------------------------------------------------------

--
-- Estructura Stand-in para la vista `vista_productos_categorias`
-- (Véase abajo para la vista actual)
--
CREATE TABLE `vista_productos_categorias` (
`id` int(11)
,`nombre` varchar(150)
,`descripcion` text
,`precio` decimal(10,2)
,`imagen` varchar(255)
,`disponible` tinyint(1)
,`destacado` tinyint(1)
,`categoria_id` int(11)
,`categoria_nombre` varchar(100)
,`categoria_descripcion` text
);

--
-- Índices para tablas volcadas
--

--
-- Indices de la tabla `carrito_temporal`
--
ALTER TABLE `carrito_temporal`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_carrito` (`usuario_id`,`producto_id`),
  ADD KEY `producto_id` (`producto_id`),
  ADD KEY `idx_carrito_usuario` (`usuario_id`);

--
-- Indices de la tabla `categorias`
--
ALTER TABLE `categorias`
  ADD PRIMARY KEY (`id`);

--
-- Indices de la tabla `favoritos`
--
ALTER TABLE `favoritos`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_favorito` (`usuario_id`,`producto_id`),
  ADD KEY `producto_id` (`producto_id`),
  ADD KEY `idx_favoritos_usuario` (`usuario_id`);

--
-- Indices de la tabla `pedidos`
--
ALTER TABLE `pedidos`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_pedidos_usuario` (`usuario_id`),
  ADD KEY `idx_pedidos_fecha` (`fecha_pedido`),
  ADD KEY `idx_pedidos_estado` (`estado`);

--
-- Indices de la tabla `pedido_detalles`
--
ALTER TABLE `pedido_detalles`
  ADD PRIMARY KEY (`id`),
  ADD KEY `producto_id` (`producto_id`),
  ADD KEY `idx_pedido_detalles_pedido` (`pedido_id`);

--
-- Indices de la tabla `productos`
--
ALTER TABLE `productos`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_productos_categoria` (`categoria_id`),
  ADD KEY `idx_productos_disponible` (`disponible`);

--
-- Indices de la tabla `usuarios`
--
ALTER TABLE `usuarios`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `email` (`email`),
  ADD KEY `idx_usuarios_email` (`email`);

--
-- AUTO_INCREMENT de las tablas volcadas
--

--
-- AUTO_INCREMENT de la tabla `carrito_temporal`
--
ALTER TABLE `carrito_temporal`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `categorias`
--
ALTER TABLE `categorias`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT de la tabla `favoritos`
--
ALTER TABLE `favoritos`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `pedidos`
--
ALTER TABLE `pedidos`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `pedido_detalles`
--
ALTER TABLE `pedido_detalles`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de la tabla `productos`
--
ALTER TABLE `productos`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=25;

--
-- AUTO_INCREMENT de la tabla `usuarios`
--
ALTER TABLE `usuarios`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

-- --------------------------------------------------------

--
-- Estructura para la vista `vista_pedidos_completos`
--
DROP TABLE IF EXISTS `vista_pedidos_completos`;

CREATE ALGORITHM=UNDEFINED DEFINER=`manuelgrupodvh`@`localhost` SQL SECURITY DEFINER VIEW `vista_pedidos_completos`  AS SELECT `ped`.`id` AS `id`, `ped`.`usuario_id` AS `usuario_id`, `u`.`nombre` AS `usuario_nombre`, `u`.`email` AS `usuario_email`, `ped`.`total` AS `total`, `ped`.`direccion_entrega` AS `direccion_entrega`, `ped`.`telefono_contacto` AS `telefono_contacto`, `ped`.`estado` AS `estado`, `ped`.`fecha_pedido` AS `fecha_pedido`, `ped`.`fecha_entrega` AS `fecha_entrega`, `ped`.`notas` AS `notas` FROM (`pedidos` `ped` join `usuarios` `u` on(`ped`.`usuario_id` = `u`.`id`)) ;

-- --------------------------------------------------------

--
-- Estructura para la vista `vista_productos_categorias`
--
DROP TABLE IF EXISTS `vista_productos_categorias`;

CREATE ALGORITHM=UNDEFINED DEFINER=`manuelgrupodvh`@`localhost` SQL SECURITY DEFINER VIEW `vista_productos_categorias`  AS SELECT `p`.`id` AS `id`, `p`.`nombre` AS `nombre`, `p`.`descripcion` AS `descripcion`, `p`.`precio` AS `precio`, `p`.`imagen` AS `imagen`, `p`.`disponible` AS `disponible`, `p`.`destacado` AS `destacado`, `c`.`id` AS `categoria_id`, `c`.`nombre` AS `categoria_nombre`, `c`.`descripcion` AS `categoria_descripcion` FROM (`productos` `p` left join `categorias` `c` on(`p`.`categoria_id` = `c`.`id`)) ;

--
-- Restricciones para tablas volcadas
--

--
-- Filtros para la tabla `carrito_temporal`
--
ALTER TABLE `carrito_temporal`
  ADD CONSTRAINT `carrito_temporal_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `carrito_temporal_ibfk_2` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE;

--
-- Filtros para la tabla `favoritos`
--
ALTER TABLE `favoritos`
  ADD CONSTRAINT `favoritos_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `favoritos_ibfk_2` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE;

--
-- Filtros para la tabla `pedidos`
--
ALTER TABLE `pedidos`
  ADD CONSTRAINT `pedidos_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE;

--
-- Filtros para la tabla `pedido_detalles`
--
ALTER TABLE `pedido_detalles`
  ADD CONSTRAINT `pedido_detalles_ibfk_1` FOREIGN KEY (`pedido_id`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `pedido_detalles_ibfk_2` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE;

--
-- Filtros para la tabla `productos`
--
ALTER TABLE `productos`
  ADD CONSTRAINT `productos_ibfk_1` FOREIGN KEY (`categoria_id`) REFERENCES `categorias` (`id`) ON DELETE SET NULL;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
