<?php
// login.php - VERSIÓN CORREGIDA PARA ANDROID
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

// INCLUIR CONEXIÓN
require_once 'db_connect.php';

// OBTENER DATOS DE ANDROID (FORMA CORRECTA)
$input = file_get_contents("php://input");
$data = json_decode($input, true);

// DEBUG: Ver qué llega
error_log("Datos recibidos de Android: " . print_r($data, true));

// VALIDAR DATOS
if (!$data || empty($data)) {
    echo json_encode([
        "success" => false,
        "message" => "No se recibieron datos. Input: " . $input
    ]);
    exit();
}

// VERIFICAR CAMPOS REQUERIDOS
if (!isset($data['email']) || !isset($data['password'])) {
    echo json_encode([
        "success" => false,
        "message" => "Faltan datos: email o password"
    ]);
    exit();
}

$email = $conexion->real_escape_string($data['email']);
$password = $data['password'];

// BUSCAR USUARIO
$sql = "SELECT id, nombre, email, password, telefono, direccion 
        FROM usuarios 
        WHERE email = '$email' 
        LIMIT 1";

$result = $conexion->query($sql);

if ($result->num_rows > 0) {
    $usuario = $result->fetch_assoc();
    
    // VERIFICAR CONTRASEÑA (hasheada en BD)
    if (password_verify($password, $usuario['password'])) {
        // ÉXITO - Remover password
        unset($usuario['password']);
        
        echo json_encode([
            "success" => true,
            "message" => "✅ Login exitoso desde XAMPP",
            "usuario" => $usuario
        ]);
    } else {
        echo json_encode([
            "success" => false,
            "message" => "❌ Contraseña incorrecta"
        ]);
    }
} else {
    echo json_encode([
        "success" => false, 
        "message" => "❌ Usuario no encontrado"
    ]);
}

$conexion->close();
?>