<?php
// register.php - VERSIÓN CORREGIDA PARA ANDROID
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

// Incluir conexión
require_once 'db_connect.php';

// Obtener datos JSON de Android
$input = file_get_contents("php://input");
$data = json_decode($input, true);

// DEBUG: Log para ver qué llega
error_log("Registro - Datos recibidos: " . print_r($data, true));

// Validar datos
if (!$data || empty($data)) {
    http_response_code(400);
    echo json_encode([
        "success" => false,
        "message" => "No se recibieron datos. Raw input: " . $input
    ]);
    exit();
}

// Validar campos requeridos
$required = ['nombre', 'email', 'password'];
foreach ($required as $field) {
    if (!isset($data[$field]) || empty(trim($data[$field]))) {
        http_response_code(400);
        echo json_encode([
            "success" => false,
            "message" => "Campo requerido faltante: " . $field
        ]);
        exit();
    }
}

// Sanitizar datos
$nombre = trim($conexion->real_escape_string($data['nombre']));
$email = trim($conexion->real_escape_string($data['email']));
$password = $data['password'];
$telefono = isset($data['telefono']) ? trim($conexion->real_escape_string($data['telefono'])) : '';
$direccion = isset($data['direccion']) ? trim($conexion->real_escape_string($data['direccion'])) : '';

// Validaciones
if (strlen($nombre) < 2) {
    echo json_encode([
        "success" => false,
        "message" => "El nombre debe tener al menos 2 caracteres"
    ]);
    exit();
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode([
        "success" => false,
        "message" => "Email inválido"
    ]);
    exit();
}

if (strlen($password) < 6) {
    echo json_encode([
        "success" => false,
        "message" => "La contraseña debe tener al menos 6 caracteres"
    ]);
    exit();
}

// Verificar si el email ya existe
$check_sql = "SELECT id FROM usuarios WHERE email = '$email'";
$check_result = $conexion->query($check_sql);

if ($check_result->num_rows > 0) {
    echo json_encode([
        "success" => false, 
        "message" => "El email ya está registrado"
    ]);
    exit();
}

// Hash de la contraseña
$password_hash = password_hash($password, PASSWORD_DEFAULT);

// Insertar nuevo usuario
$sql = "INSERT INTO usuarios (nombre, email, password, telefono, direccion) 
        VALUES ('$nombre', '$email', '$password_hash', '$telefono', '$direccion')";

if ($conexion->query($sql)) {
    $user_id = $conexion->insert_id;
    
    // Obtener datos del usuario recién creado
    $user_sql = "SELECT id, nombre, email, telefono, direccion 
                 FROM usuarios 
                 WHERE id = $user_id";
    $user_result = $conexion->query($user_sql);
    $usuario = $user_result->fetch_assoc();
    
    echo json_encode([
        "success" => true,
        "message" => "Usuario registrado exitosamente",
        "usuario" => $usuario
    ]);
} else {
    http_response_code(500);
    echo json_encode([
        "success" => false, 
        "message" => "Error al registrar: " . $conexion->error,
        "sql_error" => $conexion->error
    ]);
}

$conexion->close();
?>