<?php
// test_register.php - Para probar desde navegador/Postman
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Simular datos de Android
    $test_data = [
        "nombre" => "Usuario Test",
        "email" => "test" . rand(100, 999) . "@gmail.com",
        "password" => "123456",
        "telefono" => "987654321",
        "direccion" => "Dirección test"
    ];
    
    echo json_encode([
        "testing" => true,
        "data_sent" => $test_data,
        "message" => "Endpoint de registro funcionando"
    ]);
    
} else {
    // Mostrar formulario HTML para pruebas
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <title>Test Registro - PandaZen</title>
    </head>
    <body>
        <h2>Probar Registro desde Navegador</h2>
        <form id="registerForm">
            <input type="text" name="nombre" placeholder="Nombre" value="Flor" required><br>
            <input type="email" name="email" placeholder="Email" value="test<?= rand(100,999) ?>@gmail.com" required><br>
            <input type="password" name="password" placeholder="Password" value="123456" required><br>
            <input type="text" name="telefono" placeholder="Teléfono" value="98734532"><br>
            <input type="text" name="direccion" placeholder="Dirección" value="veille"><br>
            <button type="button" onclick="testRegister()">Probar Registro</button>
        </form>
        
        <div id="result"></div>
        
        <script>
        function testRegister() {
            const form = document.getElementById('registerForm');
            const formData = new FormData(form);
            const data = Object.fromEntries(formData);
            
            fetch('register.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(data)
            })
            .then(response => response.json())
            .then(result => {
                document.getElementById('result').innerHTML = 
                    '<pre>' + JSON.stringify(result, null, 2) + '</pre>';
            })
            .catch(error => {
                document.getElementById('result').innerHTML = 
                    'Error: ' + error;
            });
        }
        </script>
    </body>
    </html>
    <?php
}
?>